﻿//////////////////////////////////////////////
// FunctionSet.h
// 
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkDebug
{
	class TestFunction ;

	struct FunctionsDescriptor ;
}

/// Includes ---------------------------------

// nkDebug
#include "../Dll/DllDefines.h"

// nkMemory
#include <NilkinsMemory/Containers/BufferCast.h>
#include <NilkinsMemory/Containers/StringView.h>

// Standards
#include <functional>

/// Class ------------------------------------

namespace nkDebug
{
	class DLL_NKDEBUG_EXPORT FunctionSet final
	{
		public :

			// Constructor, destructor
			FunctionSet () noexcept ;
			~FunctionSet () ;

			// Pool management
			std::function<void ()> registerFunction (const char* name, std::function<void ()> func) ;
			TestFunction* getTestFunction (unsigned int index) const ;
			nkMemory::BufferCast<TestFunction*> getTestFunctions (nkMemory::StringView filter = "") const ;
			unsigned int getSetSize () const ;

		private :

			// Attributes
			FunctionsDescriptor* _set ;
	} ;
}